<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CNews extends CPlugin{
	
	var $tplvars; 

	var $media = array(
		"path"	=> "./news/",


		"tn"	=> array(
			"width"		=> "720",
			"height"	=> ""
		),

		"tn2"	=> array(
			"width"		=> "720",
			"height"	=> "406"
		)

	);

	function __construct() {
				//$this->CPlugin($db, $tables , $templates);

		$this->name = "news";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			

			switch ($sub) {

				case "settings.general":
					return $this->adminGeneralSettings();
				break;

				case "settings.advanced":
					return $this->adminAdvancedSettings();
				break;

				case "settings.static-texts":
					return $this->adminStaticTexts();
				break;


				case "texts":
					return $this->__adminTexts();
				break;

				case "landing":
					$_GET["sub"] = $sub = "items";
				case "items":
					$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"onstore" => array(&$this , "StoreRecord"),
							"ondelete" => array(&$this , "DeleteRecord"),
					);					

					return $data->DoEvents();
				break;
			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:news_items" , 
			"plugin:news_items_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));


		if (is_object($this->plugins["comments"])) {
			$widgets[] = $this->plugins["comments"]->GetCommentsWidget();
		}
		

		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					array(
						"col"	=> array(
							0 => array("size"	=> 2 ),					
							1 => array("size"	=> 8 , "widget"	=> array( "__CONTENT__" )),					
							2 => array("size"	=> 2  ),
						)
					),
					array(
						"css"	=> "no-margin-top",
						"col"	=> array(
							0 => array("size"	=> 3 ),					
							1 => array("size"	=> 6 , "widget"	=> $widgets),					
							2 => array("size"	=> 3  ),
						)
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_item"	=> $layout,
			)
		);

	}


	
}

?>